using System;
using System.Data;
using System.Reflection;
using gov.va.med.vbecs.ExceptionManagement;
using Common = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;

namespace gov.va.med.vbecs.BOL
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>Testing status business object</summary>

		#endregion

	public class TestingStatus
	{
		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="2172"> 
		///		<ExpectedInput>Valid testing status ID</ExpectedInput>
		///		<ExpectedOutput>Valid string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2173"> 
		///		<ExpectedInput>Invalid testing status ID</ExpectedInput>
		///		<ExpectedOutput>Exception</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Returns testing status text from a testing status ID
		/// </summary>
		/// <param name="testingStatusID"></param>
		/// <returns></returns>
		public static string GetTestingStatusTextFromID(int testingStatusID)
		{
			if (testingStatusID < 1)
			{
				return string.Empty;
			}
			else
			{
				return DAL.TestingStatus.GetTestingStatusTextFromID(testingStatusID);
			}

		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="2214"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="2224"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Returns a DataTable of all testing statuses
		/// </summary>
		/// <returns></returns>
		public static DataTable GetTestingStatusLookupDataTable()
		{
			return(DAL.TestingStatus.GetTestingStatusLookupList());
		
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6665"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6666"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetTestingStatusLookupList
		/// </summary>
		/// <returns>Array list of Testing statuses</returns>
		public static System.Collections.ArrayList GetTestingStatusLookupList()
		{
			DataTable dtTestingStatus;

			System.Collections.ArrayList al = new System.Collections.ArrayList();
			
			dtTestingStatus = DAL.TestingStatus.GetTestingStatusLookupList();
			
			foreach(System.Data.DataRow dtRow in dtTestingStatus.Rows)
			{
				al.Add(dtRow[Common.VbecsTables.TestingStatus.TestingStatusId] + "," + 
					dtRow[Common.VbecsTables.TestingStatus.TestingStatusText]);
			}
			return al;


		}
	}
}
